console.log("dashboard.js: 12/11/2018");

const webTCPServer = "165.73.80.85";
const webTCPPort = 9999;
const socketServer = "165.73.80.85";
const socketPort = 12063;

//-----------------------------------------------------------------------------------------
// Create a sockjs tunnel.
var net = new WebTCP(webTCPServer, webTCPPort);
// standard socket options
options = {
  encoding: "binary",
  timeout: 0,
  noDelay: true, // disable/enable Nagle algorithm
  keepAlive: true, //default is false
  initialDelay: 0 // for keepAlive. default is 0
}
// Create a socket. specify host and port of TCP server here
var socket = net.createSocket(socketServer, socketPort, options);
getTaxiRanks();

// On connection callback
socket.on('connect', function () {
  console.log('connected');
});

var dataArray = [];
socket.on('data', function (data) {
  for (var i = 0; i < data.length; i++) {
    dataArray.push(data.charCodeAt(i));
  }
  const messageType_index = 0;
  const messageType_length = 15;
  var messageType = dataArray.slice(messageType_index, messageType_index + messageType_length);
  messageType = stringFromUTF8Array(messageType);
  //console.log(messageType);
  //console.log(dataArray);
  if (messageType == "ListofTaxiRanks") {
    decodeRankData(dataArray, function (ranks) {
      //console.log(ranks);

      ranks.forEach(rank => {
        setMarker(rank);
      });

      dataArray = [];
    });


  } else {
    //var _data = dataArray; //toHexString(dataArray);
    const msgLen = 50;
    //console.log("received data length: " + dataArray.length);
    //console.log(dataArray);
    //var buff = data.split("\n");
    while (dataArray.length > msgLen) {
      var buff = dataArray.slice(0, msgLen);
      dataArray.splice(0, msgLen);

      var mapInfo = mapTaxi(buff);
      if (mapInfo != null) {
        setMarker(mapInfo.payload);
        mapTrack(mapInfo);
      }
    }
  }

});


//-----------------------------------------------------------------------------------------


function setUser() {
  user = document.getElementById("newUser").value;
  document.getElementById("newUser").value = "";
  //console.log(user);
  toggle_setUserMenu();
  if (user != "") {
    newUser = true;
    var msg = "{\"cellNumber\":\"" + user + "\"}";
    console.log(msg);
    socket.write(msg);
  }
}

function getTaxiRanks() {
  var msg = "{\"getRanks\":\"" + true + "\"}";
  console.log(msg);
  socket.write(msg);
}


// add taxi ranks to map 
function mapRank(msg) {
  var newmsg = {};
  newmsg.payload = {};
  newmsg.payload.name = msg.payload.name;
  newmsg.payload.layer = "Ranks";
  newmsg.payload.icon = "taxiRank";
  setMarker(newmsg.payload);
}

// add track to map 
function mapTrack(msg) {
  if (msg.hasOwnProperty("info") && msg.info.hasOwnProperty("dataType") && (msg.info.dataType == "initialData")) {
    return null;
  }
  if (msg.hasOwnProperty("payload") && msg.payload.hasOwnProperty("name")) {
    var newmsg = {};
    /*if (msg.payload.deleted) {
      delete pointsarray[msg.payload.name];
      //newmsg.payload.name = msg.payload.name + "_";
      setMarker(newmsg.payload); // send the track to be deleted
      return;
    }*/
    if (!pointsarray.hasOwnProperty(msg.payload.name)) {
      pointsarray[msg.payload.name] = [];
    }
    pointsarray[msg.payload.name].push(msg.payload);
    if (pointsarray[msg.payload.name].length > trackDepth) {
      pointsarray[msg.payload.name].shift();
    }
    var line = [];
    //console.log(pointsarray[msg.payload.name]);
    for (var i = 0; i < pointsarray[msg.payload.name].length; i++) {
      var m = pointsarray[msg.payload.name][i];
      if (m.hasOwnProperty("lat") && m.hasOwnProperty("lon")) {
        line.push([m.lat * 1, m.lon * 1]);
      }
    }
    if (line.length > 2) { // only send track if more than two points 
      newmsg.payload = {};
      newmsg.payload.name = msg.payload.name + "_";
      newmsg.payload.line = line;
      newmsg.payload.color = trackColor;
      newmsg.payload.layer = "Tracks";
      setMarker(newmsg.payload); // send the track
    }
  }
}

// add taxis to map
function mapTaxi(buf) {
  var msg = {};
  msg = decodeTaxiData(buf);
  //console.log(msg);

  var mapInput = {};
  var iconColor = "";

  var deviceIndex = deviceNum;
  var device = {};
  device.isStopped = null;
  device.name = null;
  device.imei = null;

  if (msg.payload.dataType == "initialData") {
    device.isStopped = msg.payload.isStopped;
    device.name = msg.payload.registrationnumber;
    device.imei = msg.payload.imei;
    var duplicate = false;
    for (i = 0; i < deviceIndex; i++) {
      if (device.imei == devices[i].imei) duplicate = true; //msg.payload.imei)  ((deviceNum > 0) && 
    }

    if (duplicate == false) {
      devices.push(device);
      deviceIndex++;
      deviceNum = deviceIndex;
    }
  } else {
    // get device parameters
    for (i = 0; i < deviceIndex; i++) {
      if (devices[i].imei == msg.payload.imei) {
        device.name = devices[i].name;
        device.isStopped = devices[i].isStopped;
        if (device.isStopped == 1) iconColor = "red";
        else iconColor = "white";
        break;
      }
    }
  }

  var Time = new Date(parseInt(msg.payload.unixtime)).toUTCString();

  mapInput = {
    payload: {
      name: device.name,
      imei: msg.payload.imei,
      lat: msg.payload.latitude,
      lon: msg.payload.longitude,
      speed: msg.payload.speed,
      bearing: msg.payload.heading,
      icon: "taxi",
      iconColor: iconColor,
      layer: "Taxis",
      Time: Time
    },
    info: {
      dataType: msg.payload.dataType,
      isStopped: device.isStopped
    }
  };

  if ((msg.payload.dataType == "navData") || (msg.payload.dataType == "initialData")) {
    //console.log(mapInput.payload);
    if (device.name !== null) return mapInput;
  } else {
    return null;
  }
}

function decodeTaxiData(buffer) {
  const imei_index = 0;
  const imei_length = 15;
  const unixtime_index = imei_index + imei_length;
  const unixtime_length = 8;
  const latlon_length = 4;
  const latlonPrecision = 10000000;
  const latitude_index = unixtime_index + unixtime_length;
  const longitude_index = latitude_index + latlon_length;
  const heading_index = longitude_index + latlon_length;
  const heading_length = 2;
  const speed_index = heading_index + heading_length;
  const speed_length = 2;
  const datatype_index = speed_index + speed_length; // Data Type
  const dataType_length = 1; // 0 = initialData;  1 = navData
  const registrationnumber_index = datatype_index + dataType_length; //------------------------------
  const registrationnumber_length = 12; // registrationnumber and
  const isStopped_index = registrationnumber_index + registrationnumber_length; // isStopped is not in navData
  const isStopped_length = 1; //------------------------------
  const initialData_length = imei_length + unixtime_length + latlon_length + latlon_length + heading_length +
    speed_length + dataType_length + registrationnumber_length + isStopped_length;
  const navData_length = imei_length + unixtime_length + latlon_length + latlon_length + heading_length +
    speed_length + dataType_length;

  //var id = buffer.slice(start, start + 1);
  var registrationnumber = buffer.slice(registrationnumber_index, registrationnumber_index +
    registrationnumber_length);
  registrationnumber = stringFromUTF8Array(registrationnumber);
  var imei = buffer.slice(imei_index, imei_index + imei_length);
  imei = stringFromUTF8Array(imei);
  var unixtime = buffer.slice(unixtime_index, unixtime_index + unixtime_length);
  unixtime = (parseInt('0x' + toHexString(unixtime))).toString(); //(parseInt('0x' + (unixtime.toString('hex')))).toString(10);
  var latitude = buffer.slice(latitude_index, latitude_index + latlon_length);
  latitude = (parseInt('0x' + toHexString(latitude) >> 0) / latlonPrecision).toString(10);
  var longitude = buffer.slice(longitude_index, longitude_index + latlon_length);
  longitude = (parseInt('0x' + toHexString(longitude) >> 0) / latlonPrecision).toString(10);
  //console.log(longitude);
  var heading = buffer.slice(heading_index, heading_index + heading_length);
  heading = parseInt('0x' + toHexString(heading));
  var speed = buffer.slice(speed_index, speed_index + speed_length);
  speed = parseInt('0x' + toHexString(speed));
  var isStopped = buffer.slice(isStopped_index, isStopped_index + isStopped_length);
  isStopped = parseInt('0x' + toHexString(isStopped));

  var datatype = buffer.slice(datatype_index, datatype_index + dataType_length);
  datatype = parseInt('0x' + toHexString(datatype));

  var result = {
    payload: {
      registrationnumber: registrationnumber,
      imei: imei,
      unixtime: unixtime,
      latitude: latitude,
      longitude: longitude,
      speed: speed,
      heading: heading,
      dataType: null,
      isStopped: isStopped
    }
  };

  if (datatype == 0) {

    result.payload.dataType = "initialData";
    //if(result.payload.registrationnumber !== null) 
    return result;
  } else if (datatype == 1) {
    result.payload.dataType = "navData";
    result.payload.isStopped = undefined;
    result.payload.registrationnumber = undefined;
    //if(result.payload.registrationnumber !== null) 
    return result;
  } else {
    return null;
  }
}

function decodeRankData(buffer, callback) {
  var ranks = [];
  const numberOfRanks_index = 15;
  const numberOfRanks_length = 2;
  const messageHeader_length = 17;
  const latlon_length = 4;
  const latlonPrecision = 10000000;
  var numberOfRanks = dataArray.slice(numberOfRanks_index, numberOfRanks_index + numberOfRanks_length);
  numberOfRanks = parseInt('0x' + toHexString(numberOfRanks));
  //console.log("numberOfRanks: " + numberOfRanks);
  // get rank data
  var rank_count = 0;
  var current_index = messageHeader_length;
  while (rank_count < numberOfRanks) {
    rank_count++;
    const rankNameLength_length = 1;
    var rankNameLength = dataArray.slice(current_index, current_index + rankNameLength_length);
    rankNameLength = parseInt('0x' + toHexString(rankNameLength));
    current_index = current_index + rankNameLength_length;
    var rankName = dataArray.slice(current_index, current_index + rankNameLength);
    rankName = stringFromUTF8Array(rankName);
    current_index = current_index + rankNameLength;
    var latitude = buffer.slice(current_index, current_index + latlon_length);
    latitude = (parseInt('0x' + toHexString(latitude) >> 0) / latlonPrecision).toString(10);
    current_index = current_index + latlon_length;
    var longitude = buffer.slice(current_index, current_index + latlon_length);
    longitude = (parseInt('0x' + toHexString(longitude) >> 0) / latlonPrecision).toString(10);
    current_index = current_index + latlon_length;
    const rankAddressLength_length = 1;
    var rankAddressLength = dataArray.slice(current_index, current_index + rankAddressLength_length);
    rankAddressLength = parseInt('0x' + toHexString(rankAddressLength));
    current_index = current_index + rankAddressLength_length;
    var rankAddress = dataArray.slice(current_index, current_index + rankAddressLength);
    rankAddress = stringFromUTF8Array(rankAddress);
    current_index = current_index + rankAddressLength;
    const rankProvinceLength_length = 1;
    var rankProvinceLength = dataArray.slice(current_index, current_index + rankProvinceLength_length);
    rankProvinceLength = parseInt('0x' + toHexString(rankProvinceLength));
    current_index = current_index + rankProvinceLength_length;
    var rankProvince = dataArray.slice(current_index, current_index + rankProvinceLength);
    rankProvince = stringFromUTF8Array(rankProvince);
    current_index = current_index + rankProvinceLength;

    var rank = {
      name: rankName,
      latitude: latitude,
      longitude: longitude,
      Address: rankAddress,
      Province: rankProvince,
      icon: "taxiRank",
      layer: "Ranks"
    };
    ranks.push(rank);
  }
  callback(ranks);
}

/*function ascii_to_hexa(str) {
  var arr1 = [];
  for (var n = 0, l = str.length; n < l; n++) {
    var hex = Number(str.charCodeAt(n)).toString(16);
    arr1.push(hex);
  }
  return arr1.join('');
}*/

function toHexString(byteArray) {
  return Array.prototype.map.call(byteArray, function (byte) {
    return ('0' + (byte & 0xFF).toString(16)).slice(-2);
  }).join('');
}

function stringFromUTF8Array(data) {
  const extraByteMap = [1, 1, 1, 1, 2, 2, 3, 0];
  var count = data.length;
  var str = "";

  for (var index = 0; index < count;) {
    var ch = data[index++];
    if (ch & 0x80) {
      var extra = extraByteMap[(ch >> 3) & 0x07];
      if (!(ch & 0x40) || !extra || ((index + extra) > count))
        return null;

      ch = ch & (0x3F >> extra);
      for (; extra > 0; extra -= 1) {
        var chx = data[index++];
        if ((chx & 0xC0) != 0x80)
          return null;

        ch = (ch << 6) | (chx & 0x3F);
      }
    }

    str += String.fromCharCode(ch);
  }

  return str;
}

/*function intFromBytes(byteArray) {
  var val = 0;
  for (var i = 0; i < byteArray.length; ++i) {
    val += byteArray[i];
    if (i < byteArray.length - 1) {
      val = val << 8;
    }
  }
  return val;
}*/