#!/usr/bin/env node
 //-------------------------------------------------------------------------------------------
var http = require('http');
var fs = require('fs');
var path = require('path')

var port = 8086;
var server = http.createServer(function (request, response) {
  //console.log((new Date()) + ' Received request for ' + request.url);
  if (request.url == "/dashboard") {
    fs.readFile('dashboard.html', function (err, data) {
      response.writeHead(200, {
        'Content-Type': 'text/html'
      });
      response.write(data);
      response.end();
    });
  } else {
    const filePath = (request.url).substring(1);
    //console.log("File Path: " + filePath);
    const contentType = setContentType(filePath);
    fs.readFile(filePath, function (err, data) {
      if (!err) {
        response.writeHead(200, {
          'Content-Type': contentType
        });
        response.write(data);
        response.end();
      } else {
        console.log((new Date()) + ' Received request for ' + request.url);
        console.log("cant find file");
        response.writeHead(404);
        response.end();
      }
    });
  }
});

server.listen(port, function () {
  console.log((new Date()) + ' Server is listening on port ' + port);
});
//-------------------------------------------------------------------------------------------

// This is a WebTCP server that is gonna be proxying 
// all client TCP requests
//-------------------------------------------------------------------------------------------
var WebTCP = require('./modules/webtcp/lib/server/webtcp.js').WebTCP
 
var dataServer = new WebTCP();
dataServer.listen(9999, "197.242.146.12");
//-------------------------------------------------------------------------------------------

function setContentType(fp) {
  const fe = path.extname(fp);
  var ct = "";
  if (fe == ".html") ct = 'text/html';
  else if (fe == ".css") ct = 'text/css';
  else if (fe == ".js") ct = 'text/javascript';
  else if (fe == ".png") ct = 'image/png';
  else if (fe == ".jpg") ct = 'image/jpg';
  else if (fe == ".ico") ct = 'image/x-icon';
  //else if (fe == "") ct = "";
  else ct = 'text/plain';
  return ct;
}