(function() {
  var GenericReceiver, MAP, ResponseReceiver, Session, SockJSConnection, Transport, closeFrame, register, stream, utils, uuid,
    __hasProp = Object.prototype.hasOwnProperty,
    __extends = function(child, parent) { for (var key in parent) { if (__hasProp.call(parent, key)) child[key] = parent[key]; } function ctor() { this.constructor = child; } ctor.prototype = parent.prototype; child.prototype = new ctor; child.__super__ = parent.prototype; return child; };

  stream = require('stream');

  uuid = require('node-uuid');

  utils = require('./utils');

  Transport = (function() {

    function Transport() {}

    return Transport;

  })();

  Transport.CONNECTING = 0;

  Transport.OPEN = 1;

  Transport.CLOSING = 2;

  Transport.CLOSED = 3;

  closeFrame = function(status, reason) {
    return 'c' + JSON.stringify([status, reason]);
  };

  SockJSConnection = (function(_super) {

    __extends(SockJSConnection, _super);

    function SockJSConnection(_session) {
      this._session = _session;
      this.id = uuid();
      this.headers = {};
      this.prefix = this._session.prefix;
    }

    SockJSConnection.prototype.toString = function() {
      return '<SockJSConnection ' + this.id + '>';
    };

    SockJSConnection.prototype.write = function(string) {
      return this._session.send('' + string);
    };

    SockJSConnection.prototype.end = function(string) {
      if (string) this.write(string);
      this.close();
      return null;
    };

    SockJSConnection.prototype.close = function(code, reason) {
      return this._session.close(code, reason);
    };

    SockJSConnection.prototype.destroy = function() {
      this.removeAllListeners();
      return this.end();
    };

    SockJSConnection.prototype.destroySoon = function() {
      return this.destroy();
    };

    return SockJSConnection;

  })(stream.Stream);

  SockJSConnection.prototype.__defineGetter__('readable', function() {
    return this._session.readyState === Transport.OPEN;
  });

  SockJSConnection.prototype.__defineGetter__('writable', function() {
    return this._session.readyState === Transport.OPEN;
  });

  SockJSConnection.prototype.__defineGetter__('readyState', function() {
    return this._session.readyState;
  });

  MAP = {};

  Session = (function() {

    function Session(session_id, server) {
      var _this = this;
      this.session_id = session_id;
      this.heartbeat_delay = server.options.heartbeat_delay;
      this.disconnect_delay = server.options.disconnect_delay;
      this.prefix = server.options.prefix;
      this.send_buffer = [];
      this.is_closing = false;
      this.readyState = Transport.CONNECTING;
      if (this.session_id) MAP[this.session_id] = this;
      this.timeout_cb = function() {
        return _this.didTimeout();
      };
      this.to_tref = setTimeout(this.timeout_cb, this.disconnect_delay);
      this.connection = new SockJSConnection(this);
      this.emit_open = function() {
        _this.emit_open = null;
        return server.emit('connection', _this.connection);
      };
    }

    Session.prototype.register = function(req, recv) {
      if (this.recv) {
        recv.doSendFrame(closeFrame(2010, "Another connection still open"));
        recv.didClose();
        return;
      }
      if (this.to_tref) {
        clearTimeout(this.to_tref);
        this.to_tref = null;
      }
      if (this.readyState === Transport.CLOSING) {
        recv.doSendFrame(this.close_frame);
        recv.didClose();
        this.to_tref = setTimeout(this.timeout_cb, this.disconnect_delay);
        return;
      }
      this.recv = recv;
      this.recv.session = this;
      this.decorateConnection(req);
      if (this.readyState === Transport.CONNECTING) {
        this.recv.doSendFrame('o');
        this.readyState = Transport.OPEN;
        process.nextTick(this.emit_open);
      }
      if (!this.recv) return;
      this.tryFlush();
    };

    Session.prototype.decorateConnection = function(req) {
      var headers, key, socket, _i, _len, _ref;
      if (!(socket = this.recv.connection)) socket = this.recv.response.connection;
      this.connection.remoteAddress = socket.remoteAddress;
      this.connection.remotePort = socket.remotePort;
      try {
        this.connection.address = socket.address();
      } catch (e) {
        this.connection.address = {};
      }
      this.connection.url = req.url;
      this.connection.pathname = req.pathname;
      this.connection.protocol = this.recv.protocol;
      headers = {};
      _ref = ['referer', 'x-client-ip', 'x-forwarded-for', 'x-cluster-client-ip', 'via', 'x-real-ip'];
      for (_i = 0, _len = _ref.length; _i < _len; _i++) {
        key = _ref[_i];
        if (req.headers[key]) headers[key] = req.headers[key];
      }
      if (headers) return this.connection.headers = headers;
    };

    Session.prototype.unregister = function() {
      this.recv.session = null;
      this.recv = null;
      if (this.to_tref) clearTimeout(this.to_tref);
      return this.to_tref = setTimeout(this.timeout_cb, this.disconnect_delay);
    };

    Session.prototype.tryFlush = function() {
      var sb, x, _ref,
        _this = this;
      if (this.send_buffer.length > 0) {
        _ref = [this.send_buffer, []], sb = _ref[0], this.send_buffer = _ref[1];
        this.recv.doSendBulk(sb);
      } else {
        if (this.to_tref) clearTimeout(this.to_tref);
        x = function() {
          if (_this.recv) {
            _this.to_tref = setTimeout(x, _this.heartbeat_delay);
            return _this.recv.doSendFrame("h");
          }
        };
        this.to_tref = setTimeout(x, this.heartbeat_delay);
      }
    };

    Session.prototype.didTimeout = function() {
      if (this.to_tref) {
        clearTimeout(this.to_tref);
        this.to_tref = null;
      }
      if (this.readyState !== Transport.CONNECTING && this.readyState !== Transport.OPEN && this.readyState !== Transport.CLOSING) {
        throw Error('INVALID_STATE_ERR');
      }
      if (this.recv) throw Error('RECV_STILL_THERE');
      this.readyState = Transport.CLOSED;
      this.connection.emit('end');
      this.connection.emit('close');
      this.connection = null;
      if (this.session_id) {
        delete MAP[this.session_id];
        return this.session_id = null;
      }
    };

    Session.prototype.didMessage = function(payload) {
      if (this.readyState === Transport.OPEN) {
        this.connection.emit('data', payload);
      }
    };

    Session.prototype.send = function(payload) {
      if (this.readyState !== Transport.OPEN) return false;
      this.send_buffer.push('' + payload);
      if (this.recv) this.tryFlush();
      return true;
    };

    Session.prototype.close = function(status, reason) {
      if (status == null) status = 1000;
      if (reason == null) reason = "Normal closure";
      if (this.readyState !== Transport.OPEN) return false;
      this.readyState = Transport.CLOSING;
      this.close_frame = closeFrame(status, reason);
      if (this.recv) {
        this.recv.doSendFrame(this.close_frame);
        this.recv.didClose();
        if (this.recv) this.unregister();
      }
      return true;
    };

    return Session;

  })();

  Session.bySessionId = function(session_id) {
    return MAP[session_id] || null;
  };

  register = function(req, server, session_id, receiver) {
    var session;
    session = Session.bySessionId(session_id);
    if (!session) session = new Session(session_id, server);
    session.register(req, receiver);
    return session;
  };

  exports.register = function(req, server, receiver) {
    return register(req, server, req.session, receiver);
  };

  exports.registerNoSession = function(req, server, receiver) {
    return register(req, server, void 0, receiver);
  };

  GenericReceiver = (function() {

    function GenericReceiver(thingy) {
      this.thingy = thingy;
      this.setUp(this.thingy);
    }

    GenericReceiver.prototype.setUp = function() {
      var _this = this;
      this.thingy_end_cb = function() {
        return _this.didAbort(1006, "Connection closed");
      };
      this.thingy.addListener('close', this.thingy_end_cb);
      return this.thingy.addListener('end', this.thingy_end_cb);
    };

    GenericReceiver.prototype.tearDown = function() {
      this.thingy.removeListener('close', this.thingy_end_cb);
      this.thingy.removeListener('end', this.thingy_end_cb);
      return this.thingy_end_cb = null;
    };

    GenericReceiver.prototype.didAbort = function(status, reason) {
      var session;
      session = this.session;
      this.didClose(status, reason);
      if (session) return session.didTimeout();
    };

    GenericReceiver.prototype.didClose = function(status, reason) {
      if (this.thingy) {
        this.tearDown(this.thingy);
        this.thingy = null;
      }
      if (this.session) return this.session.unregister(status, reason);
    };

    GenericReceiver.prototype.doSendBulk = function(messages) {
      var m, q_msgs;
      q_msgs = (function() {
        var _i, _len, _results;
        _results = [];
        for (_i = 0, _len = messages.length; _i < _len; _i++) {
          m = messages[_i];
          _results.push(utils.quote(m));
        }
        return _results;
      })();
      return this.doSendFrame('a' + '[' + q_msgs.join(',') + ']');
    };

    return GenericReceiver;

  })();

  ResponseReceiver = (function(_super) {

    __extends(ResponseReceiver, _super);

    ResponseReceiver.prototype.max_response_size = void 0;

    function ResponseReceiver(response, options) {
      this.response = response;
      this.options = options;
      this.curr_response_size = 0;
      try {
        this.response.connection.setKeepAlive(true, 5000);
      } catch (x) {

      }
      ResponseReceiver.__super__.constructor.call(this, this.response.connection);
      if (this.max_response_size === void 0) {
        this.max_response_size = this.options.response_limit;
      }
    }

    ResponseReceiver.prototype.doSendFrame = function(payload) {
      var r;
      this.curr_response_size += payload.length;
      r = false;
      try {
        this.response.write(payload);
        r = true;
      } catch (x) {

      }
      if (this.max_response_size && this.curr_response_size >= this.max_response_size) {
        this.didClose();
      }
      return r;
    };

    ResponseReceiver.prototype.didClose = function() {
      ResponseReceiver.__super__.didClose.apply(this, arguments);
      try {
        this.response.end();
      } catch (x) {

      }
      return this.response = null;
    };

    return ResponseReceiver;

  })(GenericReceiver);

  exports.GenericReceiver = GenericReceiver;

  exports.Transport = Transport;

  exports.Session = Session;

  exports.ResponseReceiver = ResponseReceiver;

  exports.SockJSConnection = SockJSConnection;

}).call(this);
