/**
 * Leaflet.UserMarker v1.0
 * 
 * Author: Jonatan Heyman <http://heyman.info>
 */

(function (window) {
  var icon = L.divIcon({
    className: "leaflet-usermarker",
    iconSize: [34, 34],
    iconAnchor: [17, 17],
    popupAnchor: [0, -20],
    labelAnchor: [11, -3],
    html: ''
  });
  var iconPulsing = L.divIcon({
    className: "leaflet-usermarker",
    iconSize: [34, 34],
    iconAnchor: [17, 17],
    popupAnchor: [0, -20],
    labelAnchor: [11, -3],
    html: '<i class="pulse"></i>'
  });

  var iconSmall = L.divIcon({
    className: "leaflet-usermarker-small",
    iconSize: [17, 17],
    iconAnchor: [9, 9],
    popupAnchor: [0, -10],
    labelAnchor: [3, -4],
    html: ''
  });
  var iconPulsingSmall = L.divIcon({
    className: "leaflet-usermarker-small",
    iconSize: [17, 17],
    iconAnchor: [9, 9],
    popupAnchor: [0, -10],
    labelAnchor: [3, -4],
    html: '<i class="pulse"></i>'
  });
  var circleStyle = {
    stroke: true,
    color: "#03f",
    weight: 3,
    opacity: 0.5,
    fillOpacity: 0.15,
    fillColor: "#03f",
    clickable: false
  };

  L.UserMarker = L.Marker.extend({
    options: {
      pulsing: false,
      smallIcon: false,
      accuracy: 0,
      circleOpts: circleStyle
    },

    initialize: function (latlng, options) {
      options = L.Util.setOptions(this, options);

      this.setPulsing(this.options.pulsing);
      this._accMarker = L.circle(latlng, this.options.accuracy, this.options.circleOpts);

      // call super
      L.Marker.prototype.initialize.call(this, latlng, this.options);

      this.on("move", function () {
        this._accMarker.setLatLng(this.getLatLng());
      }).on("remove", function () {
        this._map.removeLayer(this._accMarker);
      });
    },

    setPulsing: function (pulsing) {
      this._pulsing = pulsing;

      if (this.options.smallIcon) {
        this.setIcon(!!this._pulsing ? iconPulsingSmall : iconSmall);
      } else {
        this.setIcon(!!this._pulsing ? iconPulsing : icon);
      }
    },

    setAccuracy: function (accuracy) {
      this._accuracy = accuracy;
      if (!this._accMarker) {
        this._accMarker = L.circle(this._latlng, accuracy, this.options.circleOpts).addTo(this._map);
      } else {
        this._accMarker.setRadius(accuracy);
      }
    },

    onAdd: function (map) {
      // super
      L.Marker.prototype.onAdd.call(this, map);
      this._accMarker.addTo(map);
    }
  });

  L.userMarker = function (latlng, options) {
    return new L.UserMarker(latlng, options);
  };
})(window);