var mymap;
var meMarker = null;
var setUserMenu_Open = false;
var searchBar_Open = false;
var user = null;
var newUser = false;
var deviceNum = 0;
var devices = [];
var trackColor = "blue";
const trackDepth = 20
var pointsarray = {};

var markers = {};
var polygons = {};
var layers = {};
var overlays = {};
var basemaps = {};
var marks = [];
var marksIndex = 0;
var popid = "";
var menuOpen = false;
var clusterAt = 12;
var maxage = 600; // default max age of icons on map in seconds - cleared after 10 mins
var baselayername = "Street"; 
var initialposition = false;
var inIframe = false;
var showUserMenu = true;
var showLayerMenu = true;
var layercontrol;

var iconSz = {
  "Team/Crew": 5,
  "Squad": 10,
  "Section": 15,
  "Platoon/detachment": 20,
  "Company/battery/troop": 25,
  "Battalion/squadron": 30,
  "Regiment/group": 35,
  "Brigade": 40,
  "Division": 45,
  "Corps/MEF": 50,
  "Army": 55,
  "Army Group/front": 60,
  "Region/Theater": 65,
  "Command": 70
};

var taxiIcon = L.icon({
  iconUrl: './images/taxi-icon_s.png',
  iconSize: [28, 48], // size of the icon
  iconAnchor: [14, 24], // point of the icon which will correspond to marker's location
  popupAnchor: [0, 0] // point from which the popup should open relative to the iconAnchor
});

mymap = L.map('mapid').locate({
  flyTo: true,
  locateOptions: {
    enableHighAccuracy: true
  },
  maxZoom: 10,
  setView: 'untilPan'
});

var panit = false;

function doPanit() {
  panit = !panit;
  //console.log("Panit set :", panit);
}
/*
var heatAll = false;

function doHeatAll() {
  heatAll = !heatAll;
  //console.log("Heatall set :", heatAll);
}
*/
var lockit = false;
var mb = new L.LatLngBounds([
  [-120, -360],
  [120, 360]
]);

function doLock() {
  if (lockit) {
    lockit = false;
    mb = new L.LatLngBounds([
      [-120, -360],
      [120, 360]
    ]);
  } else {
    lockit = true;
    mb = mymap.getBounds();
    window.localStorage.setItem("lastpos", JSON.stringify(mymap.getCenter()));
    window.localStorage.setItem("lastzoom", mymap.getZoom());
    window.localStorage.setItem("lastlayer", baselayername);
    //window.localStorage.setItem("clusterat", clusterAt);
    window.localStorage.setItem("maxage", maxage);
    //console.log("Saved :", JSON.stringify(map.getCenter()), map.getZoom(), baselayername);
  }
  mymap.setMaxBounds(mb);
  //console.log("Map bounds lock :", lockit);
}

// Remove old markers
function doTidyUp(l) {
  var d = parseInt(Date.now() / 1000);
  for (var m in markers) {
    if ((l && (l == markers[m].lay)) || typeof markers[m].ts != "undefined") {
      //console.log(m,markers[m].ts,markers[m]);
      if ((l && (l == markers[m].lay)) || (markers[m].hasOwnProperty("ts") && (Number(markers[m].ts) < d) && (
          markers[m].lay !== "_drawing"))) {
        //console.log("STALE :",m);
        layers[markers[m].lay].removeLayer(markers[m]);
        if (typeof polygons[m] != "undefined") {
          layers[markers[m].lay].removeLayer(polygons[m]);
          delete polygons[m];
        }
        if (typeof polygons[m + "_"] != "undefined") {
          layers[polygons[m + "_"].lay].removeLayer(polygons[m + "_"]);
          delete polygons[m + "_"];
        }
        delete markers[m];
      }
      if (l) {
        layercontrol.removeLayer(layers[l]);
        delete overlays[l];
      }
    }
  }
}

// move the daylight / nighttime boundary (if enabled) every minute
function moveTerminator() { // if terminator line plotted move it every minute
  if (layers["_daynight"].getLayers().length > 0) {
    layers["_daynight"].clearLayers();
    layers["_daynight"].addLayer(L.terminator());
  }
}
setInterval(function () {
  moveTerminator()
}, 60000);

// Call tidyup every {maxage} seconds - default 10 mins
var stale = null;

function setMaxAge() {
  maxage = 600000;
  if (stale) {
    clearInterval(stale);
  }
  //if (maxage > 0) {
  stale = setInterval(function () {
    doTidyUp()
  }, 20000); // every 20 secs
  //} //every minute
  //console.log("Stale time set :",maxage+"s");
}
setMaxAge();

function setCluster(v) {
  clusterAt = v || 0;
  console.log("clusterAt set:", v, clusterAt);
  showMapCurrentZoom();
}

// Search for markers with names of ....
function doSearch() {
  var value = document.getElementById('search').value;
  console.log("Search for :", value);
  marks = [];
  marksIndex = 0;
  for (var key in markers) {
    if ((~(key.toLowerCase()).indexOf(value.toLowerCase())) && (mb.contains(markers[key].getLatLng()))) {
      marks.push(markers[key]);
    }
  }
  moveToMarks();
  if (lockit) {
    document.getElementById('searchRes').innerHTML = "&nbsp;<font color='#ff0'>Found " + marks.length +
      " results within bounds.</font>";
  } else {
    document.getElementById('searchRes').innerHTML = "&nbsp;<font color='#ff0'>Found " + marks.length +
      " results.</font>";
  }
}

// Jump to a markers position - centralise it on map
function moveToMarks() {
  if (marks.length > marksIndex) {
    var m = marks[marksIndex];
    mymap.setView(m.getLatLng(), mymap.getZoom());
    //m.openPopup();
    marksIndex++;
    setTimeout(moveToMarks, 2500);
  }
}


function toggle_setUserMenu() {
  setUserMenu_Open = !setUserMenu_Open;
  if (setUserMenu_Open) {
    document.getElementById("setUserMenu").style.display = 'block';
  } else {
    document.getElementById("setUserMenu").style.display = 'none';
  }
}
document.getElementById("setUserMenu").style.display = 'none';

function toggle_searchBar() {
  searchBar_Open = !searchBar_Open;
  if (searchBar_Open) {
    document.getElementById("searchBar").style.display = 'block';
    document.getElementById("results").style.display = 'block';
  } else {
    document.getElementById("searchBar").style.display = 'none';
    document.getElementById("results").style.display = 'none';
  }
}
document.getElementById("searchBar").style.display = 'none';
document.getElementById("results").style.display = 'none';

var popped = false;
var popmark = null;

mymap.on('popupopen', function (e) {
  popped = true;
  popmark = e.popup._source;
  popid = e.popup.dname;
});

mymap.on('popupclose', function (e) {
  popped = false;
});

mymap.on('overlayadd', function (e) {
  if (typeof overlays[e.name].bringToFront === "function") {
    overlays[e.name].bringToFront();
  }
  if (e.name == "satellite") {
    overlays["satellite"].bringToBack();
  }
  /*if (e.name == "heatmap") { // show heatmap button when it's layer is added.
    //document.getElementById("heat").style.display = 'block';
    clrHeat.addTo(mymap);
  }*/
  if (e.name == "day/night") {
    //console.log("add daynight");
    layers["_daynight"].addLayer(L.terminator());
  }
  if (e.name == "drawing") {
    mymap.addControl(drawControl);
    overlays["drawing"].bringToFront();
  }
});

mymap.on('overlayremove', function (e) {
  /*if (e.name == "heatmap") { // hide heatmap button when it's layer is removed.
    //document.getElementById("heat").style.display = 'none';
    clrHeat.removeFrom(mymap);
  }*/
  if (e.name == "day/night") {
    //console.log("del daynight");
    layers["_daynight"].clearLayers();
  }
  if (e.name == "drawing") {
    mymap.removeControl(drawControl);
  }
});

mymap.on('baselayerchange', function (e) {
  baselayername = e.name;
});

function showMapCurrentZoom() {
  //console.log("ZOOM:", mymap.getZoom(), ". CLUSTER:", clusterAt);
  for (var l in layers) {
    if (layers[l].hasOwnProperty("_zoom")) {
      if (mymap.getZoom() >= clusterAt) {
        layers[l].disableClustering();
      } else {
        layers[l].enableClustering();
      }
    }
  }
  setTimeout(function () {
    for (var key in markers) {
      if (polygons[key]) {
        var vis = layers[markers[key].lay].getVisibleParent(markers[key]);
        if ((vis) && (vis.hasOwnProperty("lay"))) {
          polygons[key].setStyle({
            opacity: 1
          });
        } else {
          polygons[key].setStyle({
            opacity: 0
          });
        }
        polygons[key].redraw();
      }
    }
  }, 750);
}

mymap.on('zoomend', function () {
  showMapCurrentZoom();
});

mymap.on('contextmenu', function (e) {});


function onLocationFound(e) {
  if (!meMarker) {
    meMarker = L.userMarker(e.latlng, {
      pulsing: true,
      smallIcon: true
    }).addTo(mymap);
  }
  meMarker.bindPopup("<b>This is you!</b>").closePopup();
  meMarker.setLatLng(e.latlng);
  meMarker.setAccuracy((e.accuracy) / 1);
}

function onLocationError(e) {
  alert(e.message);
}

// marker for current position
mymap.on('locationfound', onLocationFound);
mymap.on('locationerror', onLocationError);


var here_hybrid = L.tileLayer('https://{s}.{base}.maps.cit.api.here.com/maptile/2.1/{type}/{mapID}/hybrid.day/{z}/{x}/{y}/{size}/{format}?app_id={app_id}&app_code={app_code}&lg={language}', {
  attribution: 'Map &copy; 1987-2014 <a href="http://developer.here.com">HERE</a>',
  subdomains: '1234',
  mapID: 'newest',
  app_id: 'Uk76mWhYODcf3DSZsktt',
  app_code: 'DD9c0RgPl2fDBliSS3dU0A',
  base: 'aerial',
  maxZoom: 20,
  type: 'maptile',
  language: 'eng',
  format: 'png8',
  size: '256'
});
var Esri_WorldImagery = L.tileLayer('https://server.arcgisonline.com/ArcGIS/rest/services/World_Imagery/MapServer/tile/{z}/{y}/{x}', {
  attribution: 'Tiles &copy; Esri &mdash; Source: Esri, i-cubed, USDA, USGS, AEX, GeoEye, Getmapping, Aerogrid, IGN, IGP, UPR-EGP, and the GIS User Community',
  maxZoom: 20
});
var Esri_WorldStreetMap = L.tileLayer('https://server.arcgisonline.com/ArcGIS/rest/services/World_Street_Map/MapServer/tile/{z}/{y}/{x}', {
  attribution: 'Tiles &copy; Esri &mdash; Source: Esri, DeLorme, NAVTEQ, USGS, Intermap, iPC, NRCAN, Esri Japan, METI, Esri China (Hong Kong), Esri (Thailand), TomTom, 2012',
  maxZoom: 20
});
var OpenStreetMap_Mapnik = L.tileLayer('https://{s}.tile.openstreetmap.org/{z}/{x}/{y}.png', {
  maxZoom: 20,
  attribution: '&copy; <a href="http://www.openstreetmap.org/copyright">OpenStreetMap</a>'
});
/*
var mymap = L.map('mapid', {
  //layers: [OpenStreetMap_Mapnik]
}).locate({
  flyTo: true,
  locateOptions: {
    enableHighAccuracy: true
  },
  maxZoom: 10,
  setView: 'untilPan'
});
*/
basemaps = {
  "Street": OpenStreetMap_Mapnik,
  "Satellite": Esri_WorldImagery,
  "Hybrid": here_hybrid
};

// Add the day/night overlay
layers["_daynight"] = new L.LayerGroup();
overlays["day/night"] = layers["_daynight"];
/*
// Add the heatmap layer
var heat = L.heatLayer([], {
  radius: 60,
  gradient: {
    0.2: 'blue',
    0.4: 'lime',
    0.6: 'red',
    0.8: 'yellow',
    1: 'white'
  }
});
layers["_heat"] = new L.LayerGroup().addLayer(heat);
overlays["heatmap"] = layers["_heat"];
*/
if (window.localStorage.hasOwnProperty("lastlayer")) {
  if (basemaps[window.localStorage.getItem("lastlayer")]) {
    baselayername = window.localStorage.getItem("lastlayer");
  }
}
basemaps[baselayername].addTo(mymap);

// Add the search button
L.easyButton('fa fa-search fa-lg', function () {
  toggle_searchBar();
}, "Search", "topright").addTo(mymap);

// layers control
layercontrol = L.control.layers(basemaps, overlays);
layercontrol.addTo(mymap);

// Add the fullscreen button
L.control.fullscreen().addTo(mymap);

// Add the locate my position button
L.easyButton('fa-crosshairs fa-lg', function () {
  mymap.locate({
    flyTo: true,
    locateOptions: {
      enableHighAccuracy: true
    },
    maxZoom: 16,
    setView: 'untilPan'
  });
}, "Locate me").addTo(mymap);

// Add the set user button
L.easyButton('fa-user fa-lg', function () {
  toggle_setUserMenu();
}, "Set user").addTo(mymap);



function setUser() {
  user = document.getElementById("newUser").value;
  document.getElementById("newUser").value = "";
  //console.log(user);
  toggle_setUserMenu();
  if (user != "") {
    newUser = true;
    var msg = "{\"cellNumber\":\"" + user + "\"}";
    console.log(msg);
    socket.write(msg);
  }
}

//-----------------------------------------------------------------------------------------
// Create a sockjs tunnel.
var net = new WebTCP("197.242.146.12", 9999);
// standard socket options
options = {
  encoding: "binary",
  timeout: 0,
  noDelay: true, // disable/enable Nagle algorithm
  keepAlive: true, //default is false
  initialDelay: 0 // for keepAlive. default is 0
}
// Create a socket. specify host and port of TCP server here
var socket = net.createSocket("197.242.146.12", 12063, options);

// On connection callback
socket.on('connect', function () {
  console.log('connected');
});
var dataArray = [];
socket.on('data', function (data) {
  for (var i = 0; i < data.length; i++) {
    dataArray.push(data.charCodeAt(i));
  }
  //var _data = dataArray; //toHexString(dataArray);
  const msgLen = 50;
  //console.log("received data length: " + dataArray.length);
  //console.log(dataArray);
  //var buff = data.split("\n");
  while (dataArray.length > msgLen) {
    var buff = dataArray.slice(0, msgLen);
    dataArray.splice(0, msgLen);

    var mapInfo = mapData(buff);
    if (mapInfo != null) {
      setMarker(mapInfo.payload);
      MapTracks(mapInfo);
    }

  }
});
//-----------------------------------------------------------------------------------------


// Delete a marker (and notify websocket)
var delMarker = function (dname) {
  if (typeof polygons[dname] != "undefined") {
    layers[polygons[dname].lay].removeLayer(polygons[dname]);
    delete polygons[dname];
  }
  if (typeof polygons[dname + "_"] != "undefined") {
    layers[polygons[dname + "_"].lay].removeLayer(polygons[dname + "_"]);
    delete polygons[dname + "_"];
  }
  if (typeof markers[dname] != "undefined") {
    layers[markers[dname].lay].removeLayer(markers[dname]);
    mymap.removeLayer(markers[dname]);
    delete markers[dname];
  }
  ws.send(JSON.stringify({
    action: "delete",
    name: dname
  }));
  mymap.closePopup();
}


// add track to map function
function MapTracks(msg) {
  if (msg.hasOwnProperty("payload") && msg.payload.hasOwnProperty("name")) {
    var newmsg = {};
    /*if (msg.payload.deleted) {
      delete pointsarray[msg.payload.name];
      //newmsg.payload.name = msg.payload.name + "_";
      setMarker(newmsg.payload); // send the track to be deleted
      return;
    }*/
    if (!pointsarray.hasOwnProperty(msg.payload.name)) {
      pointsarray[msg.payload.name] = [];
    }
    pointsarray[msg.payload.name].push(msg.payload);
    if (pointsarray[msg.payload.name].length > trackDepth) {
      pointsarray[msg.payload.name].shift();
    }
    var line = [];
    console.log(pointsarray[msg.payload.name]);
    for (var i = 0; i < pointsarray[msg.payload.name].length; i++) {
      var m = pointsarray[msg.payload.name][i];
      if (m.hasOwnProperty("lat") && m.hasOwnProperty("lon")) {
        line.push([m.lat * 1, m.lon * 1]);
      }
    }
    if (line.length > 2) { // only send track if more than two points 
      newmsg.payload = {};
      newmsg.payload.name = msg.payload.name + "_";
      newmsg.payload.line = line;
      newmsg.payload.color = trackColor;
      newmsg.payload.layer = "Devices";
      setMarker(newmsg.payload); // send the track
    }
  }
}

// the MAIN add something to map function
function setMarker(data) {
  //console.log("DATA",typeof data, data);
  var ll;
  var lli = null;
  var stay = popped;
  var opt = {};
  opt.color = data.color || "#910000";
  opt.fillColor = data.fillColor || "#910000";
  opt.stroke = (data.hasOwnProperty("stroke")) ? data.stroke : true;
  opt.weight = data.weight || 2;
  opt.opacity = data.opacity || 1;
  opt.fillOpacity = data.fillOpacity || 0.2;
  opt.clickable = (data.hasOwnProperty("clickable")) ? data.clickable : false;
  opt.fill = (data.hasOwnProperty("fill")) ? data.fill : true;

  // Replace building
  if (data.hasOwnProperty("building")) {
    if ((data.building === "") && layers.hasOwnProperty("buildings")) {
      mymap.removeLayer(layers["buildings"]);
      layercontrol._update();
      layers["buildings"] = overlays["buildings"].set("");
      return;
    }
    //layers["buildings"] = new OSMBuildings(mymap).set(data.building);
    layers["buildings"] = overlays["buildings"].set(data.building);
    mymap.addLayer(layers["buildings"]);
    return;
  }
  var lay = data.layer || "unknown";
  if (typeof layers[lay] == "undefined") { // add layer if if doesn't exist
    //layers[lay] = new L.LayerGroup();
    console.log(data.layer);
    layers[lay] = new L.MarkerClusterGroup({
      maxClusterRadius: 50,
      spiderfyDistanceMultiplier: 1.8,
      disableClusteringAtZoom: clusterAt,
      //zoomToBoundsOnClick:true
    });
    overlays[lay] = layers[lay];
    layercontrol.addOverlay(layers[lay], lay);
    mymap.addLayer(overlays[lay]);
    console.log("ADDED LAYER", lay, layers);
  }

  if (typeof markers[data.name] != "undefined") {
    try {
      layers[lay].removeLayer(markers[data.name]);
    } catch (e) {
      console.log("OOPS");
    }
  }
  if (typeof polygons[data.name] != "undefined") {
    layers[lay].removeLayer(polygons[data.name]);
  }

  if (data.deleted) { // remove markers we are told to
    delMarker(data.name);
  } else if (data.hasOwnProperty("line") && Array.isArray(data.line)) {
    delete opt.fill;
    if (!data.hasOwnProperty("weight")) {
      opt.weight = 3;
    } //Standard settings different for lines
    if (!data.hasOwnProperty("opacity")) {
      opt.opacity = 0.8;
    }
    var polyln = L.polyline(data.line, opt);
    if (opt.clickable) {
      polyln.bindPopup(data.name);
    }
    polygons[data.name] = polyln;
    polygons[data.name].lay = lay;
    layers[lay].addLayer(polygons[data.name]);
  } else if (data.hasOwnProperty("area") && Array.isArray(data.area)) {
    var polyarea = L.polygon(data.area, opt);
    if (opt.clickable) {
      polyarea.bindPopup(data.name);
    }
    polygons[data.name] = polyarea;
    polygons[data.name].lay = lay;
    layers[lay].addLayer(polygons[data.name]);
  } else if (data.hasOwnProperty("sdlat") && data.hasOwnProperty("sdlon")) {
    if (!data.hasOwnProperty("iconColor")) {
      opt.color = "blue";
    } //different standard Color Settings
    if (!data.hasOwnProperty("fillColor")) {
      opt.fillColor = "blue";
    }
    delete opt.clickable;
    var ellipse = L.ellipse(new L.LatLng((data.lat * 1), (data.lon * 1)), [200000 * data.sdlon * Math.cos(data.lat *
      Math.PI / 180), 200000 * data.sdlat], 0, opt);
    if (data.clickable != false) {
      ellipse.on('click', function (e) {
        var popup = L.popup()
          .setLatLng(new L.LatLng((data.lat * 1), (data.lon * 1)))
          .setContent('<p><b>' + data.name + '</b><br/>lat : ' + data.lat + '<br/>lon : ' + data.lon + '</p>')
          .openOn(mymap);
      });
    }
    polygons[data.name] = ellipse;
    polygons[data.name].lay = lay;
    layers[lay].addLayer(ellipse);
  } else {
    if (data.hasOwnProperty("radius")) {
      if (data.hasOwnProperty("lat") && data.hasOwnProperty("lon")) {
        var polycirc = L.circle(new L.LatLng((data.lat * 1), (data.lon * 1)), data.radius * 1, opt);
        if (opt.clickable) {
          polycirc.bindPopup(data.name);
        }
        polygons[data.name] = polycirc;
        polygons[data.name].lay = lay;
        layers[lay].addLayer(polycirc);
      }
    }
    //console.log("handling",data.name);
    if (typeof data.coordinates == "object") {
      ll = new L.LatLng(data.coordinates[1], data.coordinates[0]);
    } else if (data.hasOwnProperty("position") && data.position.hasOwnProperty("lat") && data.position.hasOwnProperty("lon")) {
      data.lat = data.position.lat * 1;
      data.lon = data.position.lon * 1;
      data.alt = data.position.alt;
      if (parseFloat(data.position.alt) == data.position.alt) {
        data.alt = data.position.alt + " m";
      }
      delete data.position;
      ll = new L.LatLng((data.lat * 1), (data.lon * 1));
    } else if (data.hasOwnProperty("lat") && data.hasOwnProperty("lon")) {
      ll = new L.LatLng((data.lat * 1), (data.lon * 1));
    } else if (data.hasOwnProperty("latitude") && data.hasOwnProperty("longitude")) {
      ll = new L.LatLng((data.latitude * 1), (data.longitude * 1));
    } else {
      console.log("No location:", data);
      return;
    }

    // Adding new L.LatLng object (lli) when optional intensity value is defined. Only for use in heatmap layer
    if (typeof data.coordinates == "object") {
      lli = new L.LatLng(data.coordinates[2], data.coordinates[1], data.coordinates[0]);
    } else if (data.hasOwnProperty("lat") && data.hasOwnProperty("lon") && data.hasOwnProperty("intensity")) {
      lli = new L.LatLng((data.lat * 1), (data.lon * 1), (data.intensity * 1));
    } else if (data.hasOwnProperty("latitude") && data.hasOwnProperty("longitude") && data.hasOwnProperty(
        "intensity")) {
      lli = new L.LatLng((data.latitude * 1), (data.longitude * 1), (data.intensity * 1));
    } else {
      lli = ll
    }

    var words = "<b>" + data.name + "</b><br/>";

    // Create the icons... handle plane, car, ship, wind, earthquake as specials
    var marker, mymarker;
    var icon, q;
    //console.log("ICON",data.icon);
    if (data.icon === "ship") {
      marker = L.boatMarker(ll, {
        title: data.name,
        color: (data.iconColor || "blue")
      });
      marker.setHeading(data.hdg || data.bearing);
      q = 'http://www.bing.com/images/search?q=' + data.icon + '%20%2B"' + encodeURIComponent(data.name) + '"';
      words += '<a href=\'' + q + '\' target="_thingpic">Pictures</a><br>';
    } else if (data.icon === "plane") {
      data.iconColor = data.iconColor || "black";
      if (data.hasOwnProperty("squawk")) {
        data.iconColor = "red";
      }
      icon =
        '<svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" x="0px" y="0px" width="310px" height="310px" viewBox="0 0 310 310">';
      icon +=
        '<path d="M134.875,19.74c0.04-22.771,34.363-22.771,34.34,0.642v95.563L303,196.354v35.306l-133.144-43.821v71.424l30.813,24.072v27.923l-47.501-14.764l-47.501,14.764v-27.923l30.491-24.072v-71.424L3,231.66v-35.306l131.875-80.409V19.74z" fill="' +
        data.iconColor + '"/></svg>';
      var svgplane = "data:image/svg+xml;base64," + btoa(icon);
      var dir = data.hdg || data.bearing;
      myMarker = L.divIcon({
        className: "planeicon",
        iconAnchor: [16, 16],
        html: '<img src="' + svgplane + '" style="width:32px; height:32px; -webkit-transform:rotate(' + dir +
          'deg); -moz-transform:rotate(' + dir + 'deg);"/>',
      });
      marker = L.marker(ll, {
        title: data.name,
        icon: myMarker
      });
      //q = 'http://www.bing.com/images/search?q='+data.icon+'%20'+encodeURIComponent(data.name);
      //words += '<a href=\''+q+'\' target="_thingpic">Pictures</a><br>';
    } else if (data.icon === "uav") {
      data.iconColor = data.iconColor || "black";
      if (data.hasOwnProperty("squawk")) {
        data.iconColor = "red";
      }
      icon = '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 100 100">';
      icon +=
        '<path d="M62 82h-8V64h36c0-5-4-9-9-9H54v-8c0-3 4-5 4-11.1 0-4.4-3.6-8-8-8-4.4 0-8 3.6-8 8 0 5.1 4 8.1 4 11.1V55h-27c-5 0-9 4-9 9h36v18H38c-2.4 0-5 2.3-5 5L50 92l17-5C67 84.3 64.4 82 62 82z" fill="' +
        data.iconColor + '"/></svg>';
      var svguav = "data:image/svg+xml;base64," + btoa(icon);
      var dir = data.hdg || data.bearing;
      myMarker = L.divIcon({
        className: "uavicon",
        iconAnchor: [16, 16],
        html: '<img src="' + svguav + '" style="width:32px; height:32px; -webkit-transform:rotate(' + dir +
          'deg); -moz-transform:rotate(' + dir + 'deg);"/>',
      });
      marker = L.marker(ll, {
        title: data.name,
        icon: myMarker
      });
    } else if (data.icon === "car") {
      data.iconColor = data.iconColor || "black";
      icon =
        '<svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" x="0px" y="0px" width="47px" height="47px" viewBox="0 0 47 47">';
      icon +=
        '<path d="M29.395,0H17.636c-3.117,0-5.643,3.467-5.643,6.584v34.804c0,3.116,2.526,5.644,5.643,5.644h11.759   c3.116,0,5.644-2.527,5.644-5.644V6.584C35.037,3.467,32.511,0,29.395,0z M34.05,14.188v11.665l-2.729,0.351v-4.806L34.05,14.188z    M32.618,10.773c-1.016,3.9-2.219,8.51-2.219,8.51H16.631l-2.222-8.51C14.41,10.773,23.293,7.755,32.618,10.773z M15.741,21.713   v4.492l-2.73-0.349V14.502L15.741,21.713z M13.011,37.938V27.579l2.73,0.343v8.196L13.011,37.938z M14.568,40.882l2.218-3.336 h13.771l2.219,3.336H14.568z M31.321,35.805v-7.872l2.729-0.355v10.048L31.321,35.805z" fill="' +
        data.iconColor + '"/></svg>';
      var svgcar = "data:image/svg+xml;base64," + btoa(icon);
      var dir = data.hdg || data.bearing;
      myMarker = L.divIcon({
        className: "caricon",
        iconAnchor: [16, 16],
        html: '<img src="' + svgcar + '" style="width:32px; height:32px; -webkit-transform:rotate(' + dir +
          'deg); -moz-transform:rotate(' + dir + 'deg);"/>',
      });
      marker = L.marker(ll, {
        title: data.name,
        icon: myMarker
      });
    } else if (data.icon === "taxi") {
      marker = L.marker(ll, {
        title: data.name,
        icon: taxiIcon,
        rotationAngle: data.bearing,
        draggable: false
      });
    } else if (data.icon === "arrow") {
      data.iconColor = data.iconColor || "black";
      icon = '<svg xmlns="http://www.w3.org/2000/svg" width="32px" height="32px" viewBox="0 0 32 32">';
      icon += '<path d="m16.2 0.6l-10.9 31 10.7-11.1 10.5 11.1 -10.3-31z" fill="' + data.iconColor + '"/></svg>';
      var svgarrow = "data:image/svg+xml;base64," + btoa(icon);
      var dir = data.hdg || data.bearing;
      myMarker = L.divIcon({
        className: "arrowicon",
        iconAnchor: [16, 16],
        html: "'<img src='" + svgarrow +
          "' style='width:32px; height:32px; -webkit-transform:translate(0px,-16px) rotate(" + dir +
          "deg); -moz-transform:translate(0px,-16px) rotate(" + dir + "deg);'/>",
      });
      marker = L.marker(ll, {
        title: data.name,
        icon: myMarker
      });
    } else if (data.icon === "wind") {
      data.iconColor = data.iconColor || "black";
      icon = '<svg xmlns="http://www.w3.org/2000/svg" width="32px" height="32px" viewBox="0 0 32 32">';
      icon +=
        '<path d="M16.7 31.7l7-6.9c0.4-0.4 0.4-1 0-1.4 -0.4-0.4-1-0.4-1.4 0l-5.3 5.2V17.3l6.7-6.6c0.2-0.2 0.3-0.5 0.3-0.7v-9c0-0.9-1.1-1.3-1.7-0.7l-6.3 6.2L9.7 0.3C9.1-0.3 8 0.1 8 1.1v8.8c0 0.3 0.1 0.6 0.3 0.8l6.7 6.6v11.3l-5.3-5.2c-0.4-0.4-1-0.4-1.4 0 -0.4 0.4-0.4 1 0 1.4l7 6.9c0.2 0.2 0.5 0.3 0.7 0.3C16.2 32 16.5 31.9 16.7 31.7zM10 9.6V3.4l5 4.9v6.2L10 9.6zM17 8.3l5-4.9v6.2l-5 4.9V8.3z" fill="' +
        data.iconColor + '"/></svg>';
      var svgwind = "data:image/svg+xml;base64," + btoa(icon);
      var dir = data.hdg || data.bearing;
      myMarker = L.divIcon({
        className: "windicon",
        iconAnchor: [16, 16],
        html: '<img src="' + svgwind + '" style="width:32px; height:32px; -webkit-transform:rotate(' + dir +
          'deg); -moz-transform:rotate(' + dir + 'deg);"/>',
      });
      marker = L.marker(ll, {
        title: data.name,
        icon: myMarker
      });
    } else if (data.icon === "satellite") {
      data.iconColor = data.iconColor || "black";
      icon =
        '<svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" viewBox="0 0 100 100">';
      icon += '<polygon points="38.17 39.4 45.24 32.33 43.34 27.92 24.21 8.78 14.59 18.4 33.72 37.53" fill="' +
        data.iconColor + '"/>';
      icon +=
        '<path d="M69.22 44.57L54.38 29.73c-1.1-1.1-2.91-1.1-4.01 0L35.53 44.57c-1.1 1.1-1.1 2.91 0 4.01l14.84 14.84c1.1 1.1 2.91 1.1 4.01 0l14.84-14.84C70.32 47.47 70.32 45.67 69.22 44.57z" fill="' +
        data.iconColor + '"/>';
      icon += '<polygon points="71.04 55.61 66.58 53.75 59.52 60.82 61.42 65.23 80.55 84.36 90.17 74.75" fill="' +
        data.iconColor + '"/>';
      icon +=
        '<path d="M28.08 55.26l-6.05 0.59C23.11 68.13 32.78 77.94 45 79.22l0.59-6.05C36.26 72.15 28.89 64.66 28.08 55.26z" fill="' +
        data.iconColor + '"/>';
      icon +=
        '<path d="M15.88 56.54L9.83 57.13c1.67 18.06 16.03 32.43 34.08 34.09l0.59-6.04C29.34 83.76 17.29 71.71 15.88 56.54z" fill="' +
        data.iconColor + '"/>';
      icon += '</svg>';
      var svglocate = "data:image/svg+xml;base64," + btoa(icon);
      myMarker = L.divIcon({
        className: "satelliteicon",
        iconAnchor: [16, 16],
        html: '<img src="' + svglocate + '" style="width:32px; height:32px;"/>',
      });
      marker = L.marker(ll, {
        title: data.name,
        icon: myMarker
      });
    } else if (data.icon === "locate") {
      data.iconColor = data.iconColor || "cyan";
      icon =
        '<svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" x="0px" y="0px" width="468px" height="468px" viewBox="0 0 468 468">';
      icon += '<polygon points="32 32 104 32 104 0 0 0 0 104 32 104" fill="' + data.iconColor + '"/>';
      icon += '<polygon points="468 0 364 0 364 32 436 32 436 104 468 104" fill="' + data.iconColor + '"/>';
      icon += '<polygon points="0 468 104 468 104 436 32 436 32 364 0 364" fill="' + data.iconColor + '"/>';
      icon += '<polygon points="436 436 364 436 364 468 468 468 468 364 436 364" fill="' + data.iconColor + '"/>';
      //icon += '<circle cx="234" cy="234" r="22" fill="'+data.iconColor+'"/>';
      icon += '</svg>';
      var svglocate = "data:image/svg+xml;base64," + btoa(icon);
      myMarker = L.divIcon({
        className: "locateicon",
        iconAnchor: [16, 16],
        html: '<img src="' + svglocate + '" style="width:32px; height:32px;"/>',
      });
      marker = L.marker(ll, {
        title: data.name,
        icon: myMarker
      });
    } else if (data.icon === "friend") {
      marker = L.marker(ll, {
        icon: L.divIcon({
          className: 'circle f',
          iconSize: [20, 12]
        }),
        title: data.name
      });
    } else if (data.icon === "hostile") {
      marker = L.marker(ll, {
        icon: L.divIcon({
          className: 'circle h',
          iconSize: [16, 16]
        }),
        title: data.name
      });
    } else if (data.icon === "neutral") {
      marker = L.marker(ll, {
        icon: L.divIcon({
          className: 'circle n',
          iconSize: [16, 16]
        }),
        title: data.name
      });
    } else if (data.icon === "unknown") {
      marker = L.marker(ll, {
        icon: L.divIcon({
          className: 'circle',
          iconSize: [16, 16]
        }),
        title: data.name
      });
    } else if (data.icon === "danger") {
      marker = L.marker(ll, {
        icon: L.divIcon({
          className: 'up-triangle'
        }),
        title: data.name
      });
    } else if (data.icon === "earthquake") {
      marker = L.marker(ll, {
        icon: L.divIcon({
          className: 'circle e',
          iconSize: [data.mag * 5, data.mag * 5]
        }),
        title: data.name
      });
    } else if (data.hasOwnProperty("SIDC")) {
      // "SIDC":"SFGPU------E***","name":"1.C2 komp","fullname":"1.C2 komp/FTS/INSS"
      myMarker = new ms.Symbol(data.SIDC, {
        uniqueDesignation: data.name
      });
      // Now that we have a symbol we can ask for the echelon and set the symbol size
      var opts = data.options || {};
      opts.size = opts.size || iconSz[myMarker.getProperties().echelon] || 30;
      opts.size = opts.size * (opts.scale || 1);
      myMarker = myMarker.setOptions(opts);
      var myicon = L.icon({
        iconUrl: myMarker.toDataURL(),
        iconAnchor: [myMarker.getAnchor().x, myMarker.getAnchor().y],
      });
      marker = L.marker(ll, {
        title: data.name,
        icon: myicon
      });
    } else if (data.icon && (data.icon.substr(0, 3) === "fa-")) {
      var col = data.iconColor || "#910000";
      myMarker = L.divIcon({
        className: "faicon",
        html: '<center><i class="fa fa-fw fa-2x ' + data.icon + '" style="color:' + col + '"></i></center>',
        iconSize: [30, 30]
      });
      marker = L.marker(ll, {
        title: data.name,
        icon: myMarker
      });
    } else {
      myMarker = L.VectorMarkers.icon({
        icon: data.icon || "circle",
        markerColor: (data.iconColor || "#910000"),
        prefix: 'fa',
        iconColor: 'white'
      });
      marker = L.marker(ll, {
        title: data.name,
        icon: myMarker
      });
    }

    // var createLabelIcon = function(labelText) {
    //     return L.marker(new L.LatLng(51.05, -1.35), {icon:L.divIcon({ html:labelText })});
    // }

    // remove icon from list of properties, then add all others to popup
    if (data.hasOwnProperty("SIDC") && data.hasOwnProperty("options")) {
      delete data.options;
    }
    if (data.hasOwnProperty("icon") || (!data.hasOwnProperty("radius"))) {
      if (data.hasOwnProperty("icon")) {
        delete data.icon;
      }
      if (data.hasOwnProperty("iconColor")) {
        delete data.iconColor;
      }
      if (data.hasOwnProperty("photourl")) {
        words += "<img src=\"" + data.photourl + "\" style=\"width:100%; margin-top:10px;\">";
        delete data.photourl;
      }
      if (data.hasOwnProperty("photoUrl")) {
        words += "<img src=\"" + data.photoUrl + "\" style=\"width:100%; margin-top:10px;\">";
        delete data.photoUrl;
      }
      if (data.hasOwnProperty("videoUrl")) {
        words += '<video controls autoplay><source src="' + data.videoUrl +
          '" type="video/mp4">Your browser does not support the video tag.</video>';
        delete data.videoUrl;
      }
      if (data.hasOwnProperty("ttl")) { // save expiry time for this marker
        if (data.ttl != 0) {
          marker.ts = parseInt(Date.now() / 1000) + Number(data.ttl);
        }
        delete data.ttl;
      } else if (maxage != 0) {
        marker.ts = parseInt(Date.now() / 1000) + Number(maxage);
      }
      if (data.hasOwnProperty("weblink")) {
        if (typeof data.weblink === "string") {
          words += "<b><a href='" + data.weblink + "' target='_new'>more information...</a></b><br/>";
        } else {
          words += "<b><a href='" + data.weblink.url + "' target='_new'>" + data.weblink.name + "</a></b><br/>";
        }
        delete data.weblink;
      }
      for (var i in data) {
        if ((i != "name") && (i != "length")) {
          if (typeof data[i] === "object") {
            words += i + " : " + JSON.stringify(data[i]) + "<br/>";
          } else {
            words += i + " : " + data[i] + "<br/>";
          }
        }
      }
      marker.bindPopup(words, {
        keepInView: true,
        minWidth: 200
      });
      marker._popup.dname = data.name;
      marker.lay = lay; // and the layer it is on
      var rightmenuMarker = L.popup().setContent("<b>" + data.name + "</b><br/><button onclick='delMarker(\"" +
        data.name + "\");'>Delete</button>");
      marker.on('contextmenu', function (e) {
        rightmenuMarker.setLatLng(e.latlng);
        mymap.openPopup(rightmenuMarker);
      });
      /*if ((data.addtoheatmap !== "false") || (!data.hasOwnProperty("addtoheatmap"))) { // Added to give ability to control if points from active layer contribute to heatmap
        if (heatAll || mymap.hasLayer(layers[lay])) {
          heat.addLatLng(lli);
        }
      }*/
      markers[data.name] = marker;
      layers[lay].addLayer(marker);
    }

    popped = stay;
    if (popped) {
      if (popid == data.name) {
        marker.openPopup();
      } else {
        popmark.openPopup();
      }
    }
    if ((data.hdg != null) && (data.bearing == null)) {
      data.bearing = data.hdg;
      delete data.hdg;
    }
    if (data.bearing != null) { // if there is a heading
      if (data.speed != null) {
        data.length = data.speed * 50;
      } // and a speed
      if (data.length != null) {
        if (polygons[data.name] != null) {
          mymap.removeLayer(polygons[data.name]);
        }
        var x = ll.lng; // X coordinate
        var y = ll.lat * 1; // Y coordinate
        var ll1 = ll;
        var angle = data.bearing * 1;
        var lengthAsDegrees = data.length / 110540; // metres in a degree..ish
        var polygon = null;
        if (data.accuracy != null) {
          data.accuracy = Number(data.accuracy);
          var y2 = y + Math.sin((90 - angle + data.accuracy) / 180 * Math.PI) * lengthAsDegrees * Math.cos(y / 180 *
            Math.PI);
          var x2 = x + Math.cos((90 - angle + data.accuracy) / 180 * Math.PI) * lengthAsDegrees;
          var ll2 = new L.LatLng(y2, x2);
          var y3 = y + Math.sin((90 - angle - data.accuracy) / 180 * Math.PI) * lengthAsDegrees * Math.cos(y / 180 *
            Math.PI);
          var x3 = x + Math.cos((90 - angle - data.accuracy) / 180 * Math.PI) * lengthAsDegrees;
          var ll3 = new L.LatLng(y3, x3);
          polygon = L.polygon([ll1, ll2, ll3], {
            weight: 2,
            color: '#f30',
            fillOpacity: 0.06,
            clickable: false
          });
        } else {
          var ya = y + Math.sin((90 - angle) / 180 * Math.PI) * lengthAsDegrees * Math.cos(y / 180 * Math.PI);
          var xa = x + Math.cos((90 - angle) / 180 * Math.PI) * lengthAsDegrees;
          var lla = new L.LatLng(ya, xa);
          polygon = L.polygon([ll1, lla], {
            weight: 2,
            color: '#f30',
            clickable: false
          });
        }
        if (typeof layers[lay].getVisibleParent === 'function') {
          var vis = layers[lay].getVisibleParent(marker);
          if ((polygon !== null) && (vis !== null) && (!vis.hasOwnProperty("lay"))) {
            polygon.setStyle({
              opacity: 0
            });
          }
          polygons[data.name] = polygon;
          polygons[data.name].lay = lay;
          layers[lay].addLayer(polygon);
        }
      }
    }
    if (panit) {
      mymap.setView(ll, mymap.getZoom());
    }
  }
}

function mapData(buf) {
  var msg = {};
  msg = decodeData(buf);
  //console.log(msg);

  var mapInput = {};
  var iconColor = "";

  var deviceIndex = deviceNum;
  var device = {};
  device.isStopped = null;
  device.name = null;
  device.imei = null;

  if (msg.payload.dataType == "initialData") {
    device.isStopped = msg.payload.isStopped;
    device.name = msg.payload.registrationnumber;
    device.imei = msg.payload.imei;
    var duplicate = false;
    for (i = 0; i < deviceIndex; i++) {
      if (device.imei == devices[i].imei) duplicate = true; //msg.payload.imei)  ((deviceNum > 0) && 
    }

    if (duplicate == false) {
      devices.push(device);
      deviceIndex++;
      deviceNum = deviceIndex;
    }
  } else {
    // get device parameters
    for (i = 0; i < deviceIndex; i++) {
      if (devices[i].imei == msg.payload.imei) {
        device.name = devices[i].name;
        device.isStopped = devices[i].isStopped;
        if (device.isStopped == 1) iconColor = "red";
        else iconColor = "white";
        break;
      }
    }
  }

  var Time = new Date(parseInt(msg.payload.unixtime)).toUTCString();

  mapInput = {
    payload: {
      name: device.name,
      imei: msg.payload.imei,
      lat: msg.payload.latitude,
      lon: msg.payload.longitude,
      speed: msg.payload.speed,
      bearing: msg.payload.heading,
      icon: "taxi",
      iconColor: iconColor,
      layer: "Devices",
      Time: Time
    },
    info: {
      dataType: msg.payload.dataType,
      isStopped: device.isStopped
    }
  };

  if (msg.payload.dataType == "navData") {
    //console.log(mapInput.payload);
    if (device.name !== null) return mapInput;
  } else {
    return null;
  }
}

function decodeData(buffer) {
  const imei_index = 0;
  const imei_length = 15;
  const unixtime_index = imei_index + imei_length;
  const unixtime_length = 8;
  const latlon_length = 4;
  const latlonPrecision = 10000000;
  const latitude_index = unixtime_index + unixtime_length;
  const longitude_index = latitude_index + latlon_length;
  const heading_index = longitude_index + latlon_length;
  const heading_length = 2;
  const speed_index = heading_index + heading_length;
  const speed_length = 2;
  const datatype_index = speed_index + speed_length; // Data Type
  const dataType_length = 1; // 0 = initialData;  1 = navData
  const registrationnumber_index = datatype_index + dataType_length; //------------------------------
  const registrationnumber_length = 12; // registrationnumber and
  const isStopped_index = registrationnumber_index + registrationnumber_length; // isStopped is not in navData
  const isStopped_length = 1; //------------------------------
  const initialData_length = imei_length + unixtime_length + latlon_length + latlon_length + heading_length +
    speed_length + dataType_length + registrationnumber_length + isStopped_length;
  const navData_length = imei_length + unixtime_length + latlon_length + latlon_length + heading_length +
    speed_length + dataType_length;

  //var id = buffer.slice(start, start + 1);
  var registrationnumber = buffer.slice(registrationnumber_index, registrationnumber_index +
    registrationnumber_length);
  registrationnumber = stringFromUTF8Array(registrationnumber);
  var imei = buffer.slice(imei_index, imei_index + imei_length);
  imei = stringFromUTF8Array(imei);
  var unixtime = buffer.slice(unixtime_index, unixtime_index + unixtime_length);
  unixtime = (parseInt('0x' + toHexString(unixtime))).toString(); //(parseInt('0x' + (unixtime.toString('hex')))).toString(10);
  var latitude = buffer.slice(latitude_index, latitude_index + latlon_length);
  latitude = (parseInt('0x' + toHexString(latitude) >> 0) / 10000000).toString(10);
  var longitude = buffer.slice(longitude_index, longitude_index + latlon_length);
  longitude = (parseInt('0x' + toHexString(longitude) >> 0) / 10000000).toString(10);
  //console.log(longitude);
  var heading = buffer.slice(heading_index, heading_index + heading_length);
  heading = parseInt('0x' + toHexString(heading));
  var speed = buffer.slice(speed_index, speed_index + speed_length);
  speed = parseInt('0x' + toHexString(speed));
  var isStopped = buffer.slice(isStopped_index, isStopped_index + isStopped_length);
  isStopped = parseInt('0x' + toHexString(isStopped));

  var datatype = buffer.slice(datatype_index, datatype_index + dataType_length);
  datatype = parseInt('0x' + toHexString(datatype));

  var result = {
    payload: {
      registrationnumber: registrationnumber,
      imei: imei,
      unixtime: unixtime,
      latitude: latitude,
      longitude: longitude,
      speed: speed,
      heading: heading,
      dataType: null,
      isStopped: isStopped
    }
  };

  if (datatype == 0) {

    result.payload.dataType = "initialData";
    //if(result.payload.registrationnumber !== null) 
    return result;
  } else if (datatype == 1) {

    result.payload.dataType = "navData";
    result.payload.isStopped = undefined;
    result.payload.registrationnumber = undefined;
    //if(result.payload.registrationnumber !== null) 
    return result;
  } else {
    return null;
  }

}

/*function ascii_to_hexa(str) {
  var arr1 = [];
  for (var n = 0, l = str.length; n < l; n++) {
    var hex = Number(str.charCodeAt(n)).toString(16);
    arr1.push(hex);
  }
  return arr1.join('');
}*/

function toHexString(byteArray) {
  return Array.prototype.map.call(byteArray, function (byte) {
    return ('0' + (byte & 0xFF).toString(16)).slice(-2);
  }).join('');
}

function stringFromUTF8Array(data) {
  const extraByteMap = [1, 1, 1, 1, 2, 2, 3, 0];
  var count = data.length;
  var str = "";

  for (var index = 0; index < count;) {
    var ch = data[index++];
    if (ch & 0x80) {
      var extra = extraByteMap[(ch >> 3) & 0x07];
      if (!(ch & 0x40) || !extra || ((index + extra) > count))
        return null;

      ch = ch & (0x3F >> extra);
      for (; extra > 0; extra -= 1) {
        var chx = data[index++];
        if ((chx & 0xC0) != 0x80)
          return null;

        ch = (ch << 6) | (chx & 0x3F);
      }
    }

    str += String.fromCharCode(ch);
  }

  return str;
}

/*function intFromBytes(byteArray) {
  var val = 0;
  for (var i = 0; i < byteArray.length; ++i) {
    val += byteArray[i];
    if (i < byteArray.length - 1) {
      val = val << 8;
    }
  }
  return val;
}*/